<?php
/* --------------------------------------------------------------
 CoreServiceProviderRegistration.php 2020-06-02
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel\Bootstrapper;

use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Application\Plugins\PluginsServiceProvider;
use Gambio\Core\Application\ServiceProviders\Abstraction\ServiceProvider;
use Gambio\Core\Application\ServiceProviders\DoctrineQbServiceProvider;
use Gambio\Core\Auth\AuthenticationServiceProvider;
use Gambio\Core\Cache\CacheServiceProvider;
use Gambio\Core\Filesystem\FilesystemServiceProvider;
use Gambio\Core\Images\ImagesServiceProvider;
use Gambio\Core\Language\LanguageServiceProvider;
use Gambio\Core\Language\TextPhrasesServiceProvider;
use Gambio\Core\Logging\LoggingServiceProvider;
use Gambio\Core\Permission\PermissionServiceProvider;

/**
 * Class CoreServiceProviderRegistration
 * @package Gambio\Core\Application\Kernel\Bootstrapper
 *
 * Here, we register all service providers off the shop's core components.
 */
class CoreServiceProviderRegistration extends AbstractBootstrapper
{
    private const SERVICE_PROVIDERS = [
        LoggingServiceProvider::class,
        AuthenticationServiceProvider::class,
        CacheServiceProvider::class,
        DoctrineQbServiceProvider::class,
        FilesystemServiceProvider::class,
        ImagesServiceProvider::class,
        LanguageServiceProvider::class,
        PermissionServiceProvider::class,
        TextPhrasesServiceProvider::class,
        PluginsServiceProvider::class,
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        /** @var ServiceProvider $serviceProvider */
        foreach (self::SERVICE_PROVIDERS as $provider) {
            $serviceProvider = new $provider($application);
            $application->addServiceProvider($serviceProvider->toLeagueInterface());
        }
    }
}